#include<SoftwareSerial.h>
#include<Servo.h>
Servo motor;
SoftwareSerial HC12(4,3);
int trig= 5;
int echo= 2;
int angl,distance,pulse_width,tx_led=13;
void trig_pulse_ip()
 {
  digitalWrite(trig, LOW);
  delayMicroseconds(2);
  digitalWrite(trig, HIGH);
  delayMicroseconds(10);
  digitalWrite(trig, LOW);
 }
void print_serial()
 {
  Serial.print("object detected at distance ");
  Serial.print(distance); 
  Serial.println(" cm"); 
  Serial.print("at an angle ");
  Serial.print(motor.read());
  Serial.println(" deg");          
 }
void setup() 
{
  // put your setup code here, to run once:
  Serial.begin(9600);
  HC12.begin(9600);
  motor.attach(11);
  motor.write(5);
  pinMode(trig,OUTPUT);
  pinMode(tx_led,OUTPUT);  
  pinMode(echo,INPUT); 
  digitalWrite(tx_led,LOW);   
}

void loop()
{
  for(angl=5;angl<175;angl++)
    {
      motor.write(angl);
      HC12.print('s');
      trig_pulse_ip();
      pulse_width = pulseIn(echo,HIGH);
      distance = pulse_width/29/2;
      if((distance<50) && (distance>0))
        {
           digitalWrite(tx_led,HIGH);          
           transmit_distance_angle();  
           print_serial();    
           delay(100);        
           digitalWrite(tx_led,LOW);           
        } 
     delay(60);        
    }
   for(angl=175;angl>5;angl--) 
    {
      motor.write(angl);
      HC12.print('v');
      trig_pulse_ip();
      pulse_width = pulseIn(echo,HIGH);
      distance = pulse_width/29/2;
      if((distance<50) && (distance>0))
        {
           digitalWrite(tx_led,HIGH);           
           print_serial();  
           transmit_distance_angle();            
           delay(100);          
           digitalWrite(tx_led,LOW);           
        } 
     delay(60);         
    }    
}     
void transmit_distance_angle()
 {      
  if(distance<100)
    {
      HC12.print('0');
      HC12.print(distance);       
    }
  else HC12.print(distance);
  HC12.print('d');  
  if(angl<100)
    {
      HC12.print('0');
      HC12.print(angl);            
    }
  else HC12.print(angl);
  HC12.print('a');       
 }   
